varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform float		scale;
uniform vec2		time;
uniform vec2 		screenres;
vec4 				color;

vec3 ssDither(vec2 screenpos)
{
	vec3 vDither = vec3(dot(vec2(171.0,231.0), screenpos.xy + time));
	vDither = fract(vDither/vec3(103.0,71.0,97.0));
	return vDither*vec3(scale);
}

void main()
{
	color=texture2D(tex,texcoord);
	gl_FragColor.rgb = color.rgb + ssDither(texcoord*screenres.xy);
}

